# バッチ設計書 8-Batch API Types（v1）

## 概要

本ドキュメントは、Kubernetes Batch API v1のリソース型定義の設計を記述する。Job・CronJob・JobSpec・CronJobSpec・JobStatus・CronJobStatus等の構造体と、CompletionMode・ConcurrencyPolicy・PodFailurePolicy等の定数を定義するバッチ処理基盤モジュールである。

### 本バッチの処理概要

Batch API Typesは、Kubernetesのバッチ処理APIリソースの型定義を提供する内部パッケージである。Job、CronJobのデータモデルを定義し、全てのBatch APIコントローラーおよびAPIサーバーの基盤となる。

**業務上の目的・背景**：Kubernetesのバッチ処理機能（Job、CronJob）を実現するために、リソースの構造と振る舞いを型レベルで定義する必要がある。本型定義は、APIサーバーでのリソース登録、コントローラーでのリソース操作、クライアントでのリソース操作の全てにおける基盤を提供する。バリデーション、デフォルト値設定、シリアライズ、コード生成の起点となる。

**バッチの実行タイミング**：型定義モジュールのため、ランタイム実行は行わない。コンパイル時に型情報として組み込まれる。

**主要な処理内容**：
1. Job構造体定義（TypeMeta, ObjectMeta, Spec, Status）
2. JobSpec構造体定義（Parallelism, Completions, BackoffLimit, PodFailurePolicy, SuccessPolicy等）
3. JobStatus構造体定義（Conditions, Active, Succeeded, Failed等）
4. CronJob構造体定義（TypeMeta, ObjectMeta, Spec, Status）
5. CronJobSpec構造体定義（Schedule, TimeZone, ConcurrencyPolicy等）
6. CompletionMode定数定義（NonIndexed, Indexed）
7. PodFailurePolicyAction定数定義（FailJob, FailIndex, Ignore, Count）
8. PodReplacementPolicy定数定義（TerminatingOrFailed, Failed）
9. SuccessPolicy/SuccessPolicyRule構造体定義
10. ラベル・アノテーション・ファイナライザー定数定義

**前後の処理との関連**：Batch API Validation（No.9）がこの型定義に基づいてバリデーションを実施する。Batch API Defaults（No.10）がデフォルト値を設定する。Job Controller（No.1）、CronJob Controller（No.2）等が本型定義を使用する。

**影響範囲**：Batch API全体（Job/CronJobリソースの全操作）。

## バッチ種別

API型定義（データモデル定義）

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 該当なし（型定義モジュール） |
| 実行時刻 | 該当なし |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | コンパイル時に組み込み |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Goコンパイラ | Goコンパイル環境が利用可能であること |

### 実行可否判定

型定義モジュールのため、実行可否判定は不要。

## 入力仕様

### 入力パラメータ

該当なし（型定義モジュール）。

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| なし | - | 型定義のみ |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Go型定義 | Go構造体/定数 | Job, CronJob等のデータモデル |

### 出力ファイル仕様

ファイル出力はなし（型定義モジュール）。

## 処理フロー

### 処理シーケンス

```
型定義モジュールのため処理フローなし。
以下の主要型定義を提供:

1. Job / JobList 構造体
2. JobTemplateSpec 構造体
3. CompletionMode 定数（NonIndexed, Indexed）
4. PodFailurePolicyAction 定数（FailJob, FailIndex, Ignore, Count）
5. PodReplacementPolicy 定数（TerminatingOrFailed, Failed）
6. PodFailurePolicy / PodFailurePolicyRule 構造体
7. SuccessPolicy / SuccessPolicyRule 構造体
8. JobSpec 構造体（Parallelism, Completions, BackoffLimit, etc.）
9. JobStatus 構造体（Conditions, Active, Succeeded, Failed, etc.）
10. CronJob / CronJobSpec / CronJobStatus 構造体
11. ラベル定数（JobTrackingFinalizer, JobNameLabel, ControllerUidLabel等）
```

### フローチャート

```mermaid
flowchart TD
    A[types.go] --> B[Job構造体]
    A --> C[CronJob構造体]
    B --> D[JobSpec]
    B --> E[JobStatus]
    D --> F[PodFailurePolicy]
    D --> G[SuccessPolicy]
    D --> H[CompletionMode]
    C --> I[CronJobSpec]
    C --> J[CronJobStatus]
    I --> K[ConcurrencyPolicy]
```

## データベース操作仕様

### 操作別データベース影響一覧

該当なし（型定義モジュール）。

### テーブル別操作詳細

該当なし。

## エラー処理

### エラーケース一覧

該当なし（型定義モジュール）。

### リトライ仕様

該当なし。

### 障害時対応

該当なし。

## トランザクション仕様

該当なし。

## パフォーマンス要件

該当なし（型定義モジュール）。

## 排他制御

該当なし。

## ログ出力

該当なし。

## 監視・アラート

該当なし。

## 備考

- ソースコード: `pkg/apis/batch/types.go`
- labelPrefix: `batch.kubernetes.io/`
- JobTrackingFinalizer: `batch.kubernetes.io/job-tracking`
- LegacyJobNameLabel: `job-name`（プレフィックスなし、レガシー）
- LegacyControllerUidLabel: `controller-uid`（プレフィックスなし、レガシー）
- JobNameLabel: `batch.kubernetes.io/job-name`
- ControllerUidLabel: `batch.kubernetes.io/controller-uid`
- JobIndexFailureCountAnnotation: `batch.kubernetes.io/job-index-failure-count`
- JobIndexIgnoredFailureCountAnnotation: `batch.kubernetes.io/job-index-ignored-failure-count`
- JobControllerName: `kubernetes.io/job-controller`
- deepcopy生成対象: `+k8s:deepcopy-gen:interfaces=k8s.io/apimachinery/pkg/runtime.Object`
- 主要なJobSpecフィールド: Parallelism, Completions, PodFailurePolicy, SuccessPolicy, ActiveDeadlineSeconds, BackoffLimit, BackoffLimitPerIndex, MaxFailedIndexes, Selector, ManualSelector, Template, TTLSecondsAfterFinished, CompletionMode, Suspend, PodReplacementPolicy, ManagedBy
